/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.controller;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.InstructorDTO;
import pt.caf_pbs.schooldiskapi.dto.InstructorEditDTO;
import pt.caf_pbs.schooldiskapi.dto.LectureDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Instructor;
import pt.caf_pbs.schooldiskapi.model.Lecture;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Subject;

@RestController
@RequestMapping(value={"/v1/instructor"})
public class InstructorsController {
    @PutMapping(value={"{initials}"})
    public void updateInstructor(@PathVariable String initials, @RequestBody InstructorDTO instructorDTO) {
        School school = FilesOperation.loadSchool();
        school.getInstructorContainer().update(instructorDTO.getInitials(), instructorDTO.getName());
        FilesOperation.storeSchool((School)school);
    }

    @PostMapping
    public Instructor createInstructor(@RequestBody InstructorEditDTO instructorDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Instructor instructor = new Instructor(instructorDTO.getInitials(), instructorDTO.getName());
            school.getInstructorContainer().add(instructor);
            FilesOperation.storeSchool((School)school);
            return instructor;
        }
        catch (DuplicatedDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping
    public List<Instructor> getInstructors() {
        School school = FilesOperation.loadSchool();
        return school.getInstructorContainer().getInstructors();
    }

    @GetMapping(value={"{initials}"})
    public Instructor getInstructor(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Instructor instructor = school.getInstructorContainer().get(initials);
        if (instructor != null) {
            return instructor;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + initials + " found");
    }

    @DeleteMapping(value={"{initials}"})
    public void deleteInstructor(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Instructor instructor = school.getInstructorContainer().get(initials);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + initials + " found");
        }
        school.getInstructorContainer().remove(initials);
        FilesOperation.storeSchool((School)school);
    }

    @GetMapping(path={"{instructorInitials}/lecture/{subjectInitials}"})
    public Lecture getLecture(@PathVariable String instructorInitials, @PathVariable String subjectInitials) {
        School school = FilesOperation.loadSchool();
        Instructor instructor = school.getInstructorContainer().get(instructorInitials);
        if (instructor != null) {
            Lecture lecture = instructor.getLectures().get(subjectInitials);
            if (lecture != null) {
                return lecture;
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No subject with lecture with initials " + subjectInitials + " found");
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + instructorInitials + " found");
    }

    @PostMapping(path={"{instructorInitials}/lecture"})
    public Lecture createLecture(@PathVariable String instructorInitials, @RequestBody LectureDTO lectureDTO) {
        School school = FilesOperation.loadSchool();
        try {
            Instructor instructor = school.getInstructorContainer().get(instructorInitials);
            if (instructor != null) {
                Lecture lecture = new Lecture();
                Subject subject = new Subject(lectureDTO.getSubject());
                lecture.setSubject(subject);
                instructor.getLectures().add(lecture);
                FilesOperation.storeSchool((School)school);
                return lecture;
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + instructorInitials + " found");
        }
        catch (DuplicatedDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @PutMapping(path={"{instructorInitials}/lecture/{subjectInitials}"})
    public Lecture updateLecture(@PathVariable String instructorInitials, @PathVariable String subjectInitials, @RequestBody LectureDTO lectureDTO) {
        School school = FilesOperation.loadSchool();
        try {
            Instructor instructor = school.getInstructorContainer().get(instructorInitials);
            if (instructor != null) {
                Lecture lecture = instructor.getLectures().get(subjectInitials);
                if (lecture != null) {
                    Subject subject = new Subject(lectureDTO.getSubject());
                    lecture.setSubject(subject);
                    FilesOperation.storeSchool((School)school);
                    return lecture;
                }
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No lecture with subject initials " + subjectInitials + " found");
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + instructorInitials + " found");
        }
        catch (DuplicatedDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @DeleteMapping(path={"{instructorInitials}/lecture/{subjectInitials}"})
    public Lecture deleteLecture(@PathVariable String instructorInitials, @PathVariable String subjectInitials) {
        School school = FilesOperation.loadSchool();
        Instructor instructor = school.getInstructorContainer().get(instructorInitials);
        if (instructor != null) {
            Lecture lecture = instructor.getLectures().get(subjectInitials);
            if (lecture != null) {
                instructor.getLectures().remove(subjectInitials);
                FilesOperation.storeSchool((School)school);
                return lecture;
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No lecture with subject initials " + subjectInitials + " found");
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Instructor with initials " + instructorInitials + " found");
    }
}

